
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XSControl_WorkSession.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XSControl_WorkSession.hxx>
#include <TDocStd_Document.hxx>
#include <XCAFDoc_ShapeTool.hxx>
#include <StepRepr_RepresentationItem.hxx>
#include <Transfer_TransientProcess.hxx>
#include <StepShape_ConnectedFaceSet.hxx>
#include <StepRepr_NextAssemblyUsageOccurrence.hxx>
#include <STEPConstruct_Tool.hxx>
#include <StepDimTol_Datum.hxx>
#include <StepData_Factors.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XSControl_WorkSession.hxx>
#include <TDocStd_Document.hxx>
#include <StepData_Factors.hxx>

// module includes
#include <STEPCAFControl_ActorWrite.hxx>
#include <STEPCAFControl_ConfigurationNode.hxx>
#include <STEPCAFControl_Controller.hxx>
#include <STEPCAFControl_DataMapIteratorOfDataMapOfLabelExternFile.hxx>
#include <STEPCAFControl_DataMapIteratorOfDataMapOfLabelShape.hxx>
#include <STEPCAFControl_DataMapIteratorOfDataMapOfPDExternFile.hxx>
#include <STEPCAFControl_DataMapIteratorOfDataMapOfSDRExternFile.hxx>
#include <STEPCAFControl_DataMapIteratorOfDataMapOfShapePD.hxx>
#include <STEPCAFControl_DataMapIteratorOfDataMapOfShapeSDR.hxx>
#include <STEPCAFControl_DataMapOfLabelExternFile.hxx>
#include <STEPCAFControl_DataMapOfLabelShape.hxx>
#include <STEPCAFControl_DataMapOfPDExternFile.hxx>
#include <STEPCAFControl_DataMapOfSDRExternFile.hxx>
#include <STEPCAFControl_DataMapOfShapePD.hxx>
#include <STEPCAFControl_DataMapOfShapeSDR.hxx>
#include <STEPCAFControl_ExternFile.hxx>
#include <STEPCAFControl_GDTProperty.hxx>
#include <STEPCAFControl_Provider.hxx>
#include <STEPCAFControl_Reader.hxx>
#include <STEPCAFControl_Writer.hxx>

// template related includes

// ./opencascade/STEPCAFControl_DataMapOfLabelExternFile.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/STEPCAFControl_DataMapOfLabelShape.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/STEPCAFControl_DataMapOfLabelShape.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/STEPCAFControl_DataMapOfPDExternFile.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/STEPCAFControl_DataMapOfSDRExternFile.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/STEPCAFControl_DataMapOfShapePD.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/STEPCAFControl_DataMapOfShapeSDR.hxx
#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
        #include <istream>
        #include <ostream>

        using std::basic_ostream;
        using std::basic_istream;
        using std::char_traits;

        #include <DE_ConfigurationContext.hxx>
        #include <XCAFDoc_ShapeTool.hxx>

// Module definiiton
void register_STEPCAFControl(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("STEPCAFControl"));
py::object klass;

//Python trampoline classes

// classes

    // Class STEPCAFControl_ActorWrite from ./opencascade/STEPCAFControl_ActorWrite.hxx
    klass = m.attr("STEPCAFControl_ActorWrite");


    // nested enums

    static_cast<py::class_<STEPCAFControl_ActorWrite ,opencascade::handle<STEPCAFControl_ActorWrite>  , STEPControl_ActorWrite >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("IsAssembly",
             (Standard_Boolean (STEPCAFControl_ActorWrite::*)( const opencascade::handle<StepData_StepModel> & ,  TopoDS_Shape &  ) const) static_cast<Standard_Boolean (STEPCAFControl_ActorWrite::*)( const opencascade::handle<StepData_StepModel> & ,  TopoDS_Shape &  ) const>(&STEPCAFControl_ActorWrite::IsAssembly),
             R"#(Check whether shape S is assembly Returns True if shape is registered in assemblies map)#"  , py::arg("theModel"),  py::arg("S")
          )
        .def("SetStdMode",
             (void (STEPCAFControl_ActorWrite::*)( const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_ActorWrite::*)( const Standard_Boolean  ) >(&STEPCAFControl_ActorWrite::SetStdMode),
             R"#(Set standard mode of work In standard mode Actor (default) behaves exactly as its ancestor, also map is cleared)#"  , py::arg("stdmode")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def("ClearMap",
             (void (STEPCAFControl_ActorWrite::*)() ) static_cast<void (STEPCAFControl_ActorWrite::*)() >(&STEPCAFControl_ActorWrite::ClearMap),
             R"#(Clears map of shapes registered as assemblies)#" 
          )
        .def("RegisterAssembly",
             (void (STEPCAFControl_ActorWrite::*)( const TopoDS_Shape &  ) ) static_cast<void (STEPCAFControl_ActorWrite::*)( const TopoDS_Shape &  ) >(&STEPCAFControl_ActorWrite::RegisterAssembly),
             R"#(Registers shape to be written as assembly The shape should be TopoDS_Compound (else does nothing))#"  , py::arg("S")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&STEPCAFControl_ActorWrite::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&STEPCAFControl_ActorWrite::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (STEPCAFControl_ActorWrite::*)() const) static_cast<const opencascade::handle<Standard_Type> & (STEPCAFControl_ActorWrite::*)() const>(&STEPCAFControl_ActorWrite::DynamicType),
             R"#(None)#"
             
         )
;

    // Class STEPCAFControl_ConfigurationNode from ./opencascade/STEPCAFControl_ConfigurationNode.hxx
    klass = m.attr("STEPCAFControl_ConfigurationNode");


    // nested enums

    static_cast<py::class_<STEPCAFControl_ConfigurationNode ,opencascade::handle<STEPCAFControl_ConfigurationNode>  , DE_ConfigurationNode >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const opencascade::handle<STEPCAFControl_ConfigurationNode> & >()  , py::arg("theNode") )
    // custom constructors
    // methods
        .def("Load",
             (bool (STEPCAFControl_ConfigurationNode::*)( const opencascade::handle<DE_ConfigurationContext> &  ) ) static_cast<bool (STEPCAFControl_ConfigurationNode::*)( const opencascade::handle<DE_ConfigurationContext> &  ) >(&STEPCAFControl_ConfigurationNode::Load),
             R"#(Updates values according the resource)#"  , py::arg("theResource")
          )
        .def("Save",
             (TCollection_AsciiString (STEPCAFControl_ConfigurationNode::*)() const) static_cast<TCollection_AsciiString (STEPCAFControl_ConfigurationNode::*)() const>(&STEPCAFControl_ConfigurationNode::Save),
             R"#(Writes configuration to the string)#" 
          )
        .def("Copy",
             (opencascade::handle<DE_ConfigurationNode> (STEPCAFControl_ConfigurationNode::*)() const) static_cast<opencascade::handle<DE_ConfigurationNode> (STEPCAFControl_ConfigurationNode::*)() const>(&STEPCAFControl_ConfigurationNode::Copy),
             R"#(Copies values of all fields)#" 
          )
        .def("BuildProvider",
             (opencascade::handle<DE_Provider> (STEPCAFControl_ConfigurationNode::*)() ) static_cast<opencascade::handle<DE_Provider> (STEPCAFControl_ConfigurationNode::*)() >(&STEPCAFControl_ConfigurationNode::BuildProvider),
             R"#(Creates new provider for the own format)#" 
          )
        .def("IsImportSupported",
             (bool (STEPCAFControl_ConfigurationNode::*)() const) static_cast<bool (STEPCAFControl_ConfigurationNode::*)() const>(&STEPCAFControl_ConfigurationNode::IsImportSupported),
             R"#(Checks the import supporting)#" 
          )
        .def("IsExportSupported",
             (bool (STEPCAFControl_ConfigurationNode::*)() const) static_cast<bool (STEPCAFControl_ConfigurationNode::*)() const>(&STEPCAFControl_ConfigurationNode::IsExportSupported),
             R"#(Checks the export supporting)#" 
          )
        .def("GetFormat",
             (TCollection_AsciiString (STEPCAFControl_ConfigurationNode::*)() const) static_cast<TCollection_AsciiString (STEPCAFControl_ConfigurationNode::*)() const>(&STEPCAFControl_ConfigurationNode::GetFormat),
             R"#(Gets CAD format name of associated provider)#" 
          )
        .def("GetVendor",
             (TCollection_AsciiString (STEPCAFControl_ConfigurationNode::*)() const) static_cast<TCollection_AsciiString (STEPCAFControl_ConfigurationNode::*)() const>(&STEPCAFControl_ConfigurationNode::GetVendor),
             R"#(Gets provider's vendor name of associated provider)#" 
          )
        .def("GetExtensions",
             (TColStd_ListOfAsciiString (STEPCAFControl_ConfigurationNode::*)() const) static_cast<TColStd_ListOfAsciiString (STEPCAFControl_ConfigurationNode::*)() const>(&STEPCAFControl_ConfigurationNode::GetExtensions),
             R"#(Gets list of supported file extensions)#" 
          )
        .def("CheckContent",
             (bool (STEPCAFControl_ConfigurationNode::*)( const opencascade::handle<NCollection_Buffer> &  ) const) static_cast<bool (STEPCAFControl_ConfigurationNode::*)( const opencascade::handle<NCollection_Buffer> &  ) const>(&STEPCAFControl_ConfigurationNode::CheckContent),
             R"#(Checks the file content to verify a format)#"  , py::arg("theBuffer")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&STEPCAFControl_ConfigurationNode::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&STEPCAFControl_ConfigurationNode::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("InternalParameters", &STEPCAFControl_ConfigurationNode::InternalParameters)
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (STEPCAFControl_ConfigurationNode::*)() const) static_cast<const opencascade::handle<Standard_Type> & (STEPCAFControl_ConfigurationNode::*)() const>(&STEPCAFControl_ConfigurationNode::DynamicType),
             R"#(None)#"
             
         )
;

    // Class STEPCAFControl_Controller from ./opencascade/STEPCAFControl_Controller.hxx
    klass = m.attr("STEPCAFControl_Controller");


    // nested enums

    static_cast<py::class_<STEPCAFControl_Controller ,opencascade::handle<STEPCAFControl_Controller>  , STEPControl_Controller >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Init_s",
                    (Standard_Boolean (*)() ) static_cast<Standard_Boolean (*)() >(&STEPCAFControl_Controller::Init),
                    R"#(Standard Initialisation. It creates a Controller for STEP-XCAF and records it to various names, available to select it later Returns True when done, False if could not be done)#" 
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&STEPCAFControl_Controller::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&STEPCAFControl_Controller::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (STEPCAFControl_Controller::*)() const) static_cast<const opencascade::handle<Standard_Type> & (STEPCAFControl_Controller::*)() const>(&STEPCAFControl_Controller::DynamicType),
             R"#(None)#"
             
         )
;

    // Class STEPCAFControl_ExternFile from ./opencascade/STEPCAFControl_ExternFile.hxx
    klass = m.attr("STEPCAFControl_ExternFile");


    // nested enums

    static_cast<py::class_<STEPCAFControl_ExternFile ,opencascade::handle<STEPCAFControl_ExternFile>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("SetWS",
             (void (STEPCAFControl_ExternFile::*)( const opencascade::handle<XSControl_WorkSession> &  ) ) static_cast<void (STEPCAFControl_ExternFile::*)( const opencascade::handle<XSControl_WorkSession> &  ) >(&STEPCAFControl_ExternFile::SetWS),
             R"#(None)#"  , py::arg("WS")
          )
        .def("GetWS",
             (opencascade::handle<XSControl_WorkSession> (STEPCAFControl_ExternFile::*)() const) static_cast<opencascade::handle<XSControl_WorkSession> (STEPCAFControl_ExternFile::*)() const>(&STEPCAFControl_ExternFile::GetWS),
             R"#(None)#" 
          )
        .def("SetLoadStatus",
             (void (STEPCAFControl_ExternFile::*)( const IFSelect_ReturnStatus  ) ) static_cast<void (STEPCAFControl_ExternFile::*)( const IFSelect_ReturnStatus  ) >(&STEPCAFControl_ExternFile::SetLoadStatus),
             R"#(None)#"  , py::arg("stat")
          )
        .def("GetLoadStatus",
             (IFSelect_ReturnStatus (STEPCAFControl_ExternFile::*)() const) static_cast<IFSelect_ReturnStatus (STEPCAFControl_ExternFile::*)() const>(&STEPCAFControl_ExternFile::GetLoadStatus),
             R"#(None)#" 
          )
        .def("SetTransferStatus",
             (void (STEPCAFControl_ExternFile::*)( const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_ExternFile::*)( const Standard_Boolean  ) >(&STEPCAFControl_ExternFile::SetTransferStatus),
             R"#(None)#"  , py::arg("isok")
          )
        .def("GetTransferStatus",
             (Standard_Boolean (STEPCAFControl_ExternFile::*)() const) static_cast<Standard_Boolean (STEPCAFControl_ExternFile::*)() const>(&STEPCAFControl_ExternFile::GetTransferStatus),
             R"#(None)#" 
          )
        .def("SetWriteStatus",
             (void (STEPCAFControl_ExternFile::*)( const IFSelect_ReturnStatus  ) ) static_cast<void (STEPCAFControl_ExternFile::*)( const IFSelect_ReturnStatus  ) >(&STEPCAFControl_ExternFile::SetWriteStatus),
             R"#(None)#"  , py::arg("stat")
          )
        .def("GetWriteStatus",
             (IFSelect_ReturnStatus (STEPCAFControl_ExternFile::*)() const) static_cast<IFSelect_ReturnStatus (STEPCAFControl_ExternFile::*)() const>(&STEPCAFControl_ExternFile::GetWriteStatus),
             R"#(None)#" 
          )
        .def("SetName",
             (void (STEPCAFControl_ExternFile::*)( const opencascade::handle<TCollection_HAsciiString> &  ) ) static_cast<void (STEPCAFControl_ExternFile::*)( const opencascade::handle<TCollection_HAsciiString> &  ) >(&STEPCAFControl_ExternFile::SetName),
             R"#(None)#"  , py::arg("name")
          )
        .def("GetName",
             (opencascade::handle<TCollection_HAsciiString> (STEPCAFControl_ExternFile::*)() const) static_cast<opencascade::handle<TCollection_HAsciiString> (STEPCAFControl_ExternFile::*)() const>(&STEPCAFControl_ExternFile::GetName),
             R"#(None)#" 
          )
        .def("SetLabel",
             (void (STEPCAFControl_ExternFile::*)( const TDF_Label &  ) ) static_cast<void (STEPCAFControl_ExternFile::*)( const TDF_Label &  ) >(&STEPCAFControl_ExternFile::SetLabel),
             R"#(None)#"  , py::arg("L")
          )
        .def("GetLabel",
             (TDF_Label (STEPCAFControl_ExternFile::*)() const) static_cast<TDF_Label (STEPCAFControl_ExternFile::*)() const>(&STEPCAFControl_ExternFile::GetLabel),
             R"#(None)#" 
          )
        .def("SetWS",
             (void (STEPCAFControl_ExternFile::*)( const opencascade::handle<XSControl_WorkSession> &  ) ) static_cast<void (STEPCAFControl_ExternFile::*)( const opencascade::handle<XSControl_WorkSession> &  ) >(&STEPCAFControl_ExternFile::SetWS),
             R"#(None)#"  , py::arg("WS")
          )
        .def("GetWS",
             (opencascade::handle<XSControl_WorkSession> (STEPCAFControl_ExternFile::*)() const) static_cast<opencascade::handle<XSControl_WorkSession> (STEPCAFControl_ExternFile::*)() const>(&STEPCAFControl_ExternFile::GetWS),
             R"#(None)#" 
          )
        .def("SetLoadStatus",
             (void (STEPCAFControl_ExternFile::*)( const IFSelect_ReturnStatus  ) ) static_cast<void (STEPCAFControl_ExternFile::*)( const IFSelect_ReturnStatus  ) >(&STEPCAFControl_ExternFile::SetLoadStatus),
             R"#(None)#"  , py::arg("stat")
          )
        .def("GetLoadStatus",
             (IFSelect_ReturnStatus (STEPCAFControl_ExternFile::*)() const) static_cast<IFSelect_ReturnStatus (STEPCAFControl_ExternFile::*)() const>(&STEPCAFControl_ExternFile::GetLoadStatus),
             R"#(None)#" 
          )
        .def("SetTransferStatus",
             (void (STEPCAFControl_ExternFile::*)( const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_ExternFile::*)( const Standard_Boolean  ) >(&STEPCAFControl_ExternFile::SetTransferStatus),
             R"#(None)#"  , py::arg("isok")
          )
        .def("GetTransferStatus",
             (Standard_Boolean (STEPCAFControl_ExternFile::*)() const) static_cast<Standard_Boolean (STEPCAFControl_ExternFile::*)() const>(&STEPCAFControl_ExternFile::GetTransferStatus),
             R"#(None)#" 
          )
        .def("SetWriteStatus",
             (void (STEPCAFControl_ExternFile::*)( const IFSelect_ReturnStatus  ) ) static_cast<void (STEPCAFControl_ExternFile::*)( const IFSelect_ReturnStatus  ) >(&STEPCAFControl_ExternFile::SetWriteStatus),
             R"#(None)#"  , py::arg("stat")
          )
        .def("GetWriteStatus",
             (IFSelect_ReturnStatus (STEPCAFControl_ExternFile::*)() const) static_cast<IFSelect_ReturnStatus (STEPCAFControl_ExternFile::*)() const>(&STEPCAFControl_ExternFile::GetWriteStatus),
             R"#(None)#" 
          )
        .def("SetName",
             (void (STEPCAFControl_ExternFile::*)( const opencascade::handle<TCollection_HAsciiString> &  ) ) static_cast<void (STEPCAFControl_ExternFile::*)( const opencascade::handle<TCollection_HAsciiString> &  ) >(&STEPCAFControl_ExternFile::SetName),
             R"#(None)#"  , py::arg("name")
          )
        .def("GetName",
             (opencascade::handle<TCollection_HAsciiString> (STEPCAFControl_ExternFile::*)() const) static_cast<opencascade::handle<TCollection_HAsciiString> (STEPCAFControl_ExternFile::*)() const>(&STEPCAFControl_ExternFile::GetName),
             R"#(None)#" 
          )
        .def("SetLabel",
             (void (STEPCAFControl_ExternFile::*)( const TDF_Label &  ) ) static_cast<void (STEPCAFControl_ExternFile::*)( const TDF_Label &  ) >(&STEPCAFControl_ExternFile::SetLabel),
             R"#(None)#"  , py::arg("Label")
          )
        .def("GetLabel",
             (TDF_Label (STEPCAFControl_ExternFile::*)() const) static_cast<TDF_Label (STEPCAFControl_ExternFile::*)() const>(&STEPCAFControl_ExternFile::GetLabel),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&STEPCAFControl_ExternFile::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&STEPCAFControl_ExternFile::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (STEPCAFControl_ExternFile::*)() const) static_cast<const opencascade::handle<Standard_Type> & (STEPCAFControl_ExternFile::*)() const>(&STEPCAFControl_ExternFile::DynamicType),
             R"#(None)#"
             
         )
;

    // Class STEPCAFControl_GDTProperty from ./opencascade/STEPCAFControl_GDTProperty.hxx
    klass = m.attr("STEPCAFControl_GDTProperty");


    // nested enums

    static_cast<py::class_<STEPCAFControl_GDTProperty , shared_ptr<STEPCAFControl_GDTProperty>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("GetDimModifiers_s",
                    (void (*)( const opencascade::handle<StepRepr_CompoundRepresentationItem> & ,  NCollection_Sequence<XCAFDimTolObjects_DimensionModif> &  ) ) static_cast<void (*)( const opencascade::handle<StepRepr_CompoundRepresentationItem> & ,  NCollection_Sequence<XCAFDimTolObjects_DimensionModif> &  ) >(&STEPCAFControl_GDTProperty::GetDimModifiers),
                    R"#(None)#"  , py::arg("theCRI"),  py::arg("theModifiers")
          )
        .def_static("GetDimType_s",
                    (Standard_Boolean (*)( const opencascade::handle<TCollection_HAsciiString> & ,  XCAFDimTolObjects_DimensionType &  ) ) static_cast<Standard_Boolean (*)( const opencascade::handle<TCollection_HAsciiString> & ,  XCAFDimTolObjects_DimensionType &  ) >(&STEPCAFControl_GDTProperty::GetDimType),
                    R"#(None)#"  , py::arg("theName"),  py::arg("theType")
          )
        .def_static("GetDatumTargetType_s",
                    (Standard_Boolean (*)( const opencascade::handle<TCollection_HAsciiString> & ,  XCAFDimTolObjects_DatumTargetType &  ) ) static_cast<Standard_Boolean (*)( const opencascade::handle<TCollection_HAsciiString> & ,  XCAFDimTolObjects_DatumTargetType &  ) >(&STEPCAFControl_GDTProperty::GetDatumTargetType),
                    R"#(None)#"  , py::arg("theDescription"),  py::arg("theType")
          )
        .def_static("GetDimQualifierType_s",
                    (Standard_Boolean (*)( const opencascade::handle<TCollection_HAsciiString> & ,  XCAFDimTolObjects_DimensionQualifier &  ) ) static_cast<Standard_Boolean (*)( const opencascade::handle<TCollection_HAsciiString> & ,  XCAFDimTolObjects_DimensionQualifier &  ) >(&STEPCAFControl_GDTProperty::GetDimQualifierType),
                    R"#(None)#"  , py::arg("theDescription"),  py::arg("theType")
          )
        .def_static("GetTolValueType_s",
                    (Standard_Boolean (*)( const opencascade::handle<TCollection_HAsciiString> & ,  XCAFDimTolObjects_GeomToleranceTypeValue &  ) ) static_cast<Standard_Boolean (*)( const opencascade::handle<TCollection_HAsciiString> & ,  XCAFDimTolObjects_GeomToleranceTypeValue &  ) >(&STEPCAFControl_GDTProperty::GetTolValueType),
                    R"#(None)#"  , py::arg("theDescription"),  py::arg("theType")
          )
        .def_static("GetTolValueType_s",
                    (opencascade::handle<TCollection_HAsciiString> (*)( const XCAFDimTolObjects_GeomToleranceTypeValue &  ) ) static_cast<opencascade::handle<TCollection_HAsciiString> (*)( const XCAFDimTolObjects_GeomToleranceTypeValue &  ) >(&STEPCAFControl_GDTProperty::GetTolValueType),
                    R"#(None)#"  , py::arg("theType")
          )
        .def_static("GetDimTypeName_s",
                    (opencascade::handle<TCollection_HAsciiString> (*)( const XCAFDimTolObjects_DimensionType  ) ) static_cast<opencascade::handle<TCollection_HAsciiString> (*)( const XCAFDimTolObjects_DimensionType  ) >(&STEPCAFControl_GDTProperty::GetDimTypeName),
                    R"#(None)#"  , py::arg("theType")
          )
        .def_static("GetDimQualifierName_s",
                    (opencascade::handle<TCollection_HAsciiString> (*)( const XCAFDimTolObjects_DimensionQualifier  ) ) static_cast<opencascade::handle<TCollection_HAsciiString> (*)( const XCAFDimTolObjects_DimensionQualifier  ) >(&STEPCAFControl_GDTProperty::GetDimQualifierName),
                    R"#(None)#"  , py::arg("theQualifier")
          )
        .def_static("GetDimModifierName_s",
                    (opencascade::handle<TCollection_HAsciiString> (*)( const XCAFDimTolObjects_DimensionModif  ) ) static_cast<opencascade::handle<TCollection_HAsciiString> (*)( const XCAFDimTolObjects_DimensionModif  ) >(&STEPCAFControl_GDTProperty::GetDimModifierName),
                    R"#(None)#"  , py::arg("theModifier")
          )
        .def_static("GetLimitsAndFits_s",
                    (opencascade::handle<StepShape_LimitsAndFits> (*)( Standard_Boolean ,  XCAFDimTolObjects_DimensionFormVariance ,  XCAFDimTolObjects_DimensionGrade  ) ) static_cast<opencascade::handle<StepShape_LimitsAndFits> (*)( Standard_Boolean ,  XCAFDimTolObjects_DimensionFormVariance ,  XCAFDimTolObjects_DimensionGrade  ) >(&STEPCAFControl_GDTProperty::GetLimitsAndFits),
                    R"#(None)#"  , py::arg("theHole"),  py::arg("theFormVariance"),  py::arg("theGrade")
          )
        .def_static("GetDatumTargetName_s",
                    (opencascade::handle<TCollection_HAsciiString> (*)( const XCAFDimTolObjects_DatumTargetType  ) ) static_cast<opencascade::handle<TCollection_HAsciiString> (*)( const XCAFDimTolObjects_DatumTargetType  ) >(&STEPCAFControl_GDTProperty::GetDatumTargetName),
                    R"#(None)#"  , py::arg("theDatumType")
          )
        .def_static("IsDimensionalLocation_s",
                    (Standard_Boolean (*)( const XCAFDimTolObjects_DimensionType  ) ) static_cast<Standard_Boolean (*)( const XCAFDimTolObjects_DimensionType  ) >(&STEPCAFControl_GDTProperty::IsDimensionalLocation),
                    R"#(None)#"  , py::arg("theType")
          )
        .def_static("IsDimensionalSize_s",
                    (Standard_Boolean (*)( const XCAFDimTolObjects_DimensionType  ) ) static_cast<Standard_Boolean (*)( const XCAFDimTolObjects_DimensionType  ) >(&STEPCAFControl_GDTProperty::IsDimensionalSize),
                    R"#(None)#"  , py::arg("theType")
          )
        .def_static("GetGeomToleranceType_s",
                    (StepDimTol_GeometricToleranceType (*)( const XCAFDimTolObjects_GeomToleranceType  ) ) static_cast<StepDimTol_GeometricToleranceType (*)( const XCAFDimTolObjects_GeomToleranceType  ) >(&STEPCAFControl_GDTProperty::GetGeomToleranceType),
                    R"#(None)#"  , py::arg("theType")
          )
        .def_static("GetGeomToleranceType_s",
                    (XCAFDimTolObjects_GeomToleranceType (*)( const StepDimTol_GeometricToleranceType  ) ) static_cast<XCAFDimTolObjects_GeomToleranceType (*)( const StepDimTol_GeometricToleranceType  ) >(&STEPCAFControl_GDTProperty::GetGeomToleranceType),
                    R"#(None)#"  , py::arg("theType")
          )
        .def_static("GetGeomTolerance_s",
                    (opencascade::handle<StepDimTol_GeometricTolerance> (*)( const XCAFDimTolObjects_GeomToleranceType  ) ) static_cast<opencascade::handle<StepDimTol_GeometricTolerance> (*)( const XCAFDimTolObjects_GeomToleranceType  ) >(&STEPCAFControl_GDTProperty::GetGeomTolerance),
                    R"#(None)#"  , py::arg("theType")
          )
        .def_static("GetGeomToleranceModifier_s",
                    (StepDimTol_GeometricToleranceModifier (*)( const XCAFDimTolObjects_GeomToleranceModif  ) ) static_cast<StepDimTol_GeometricToleranceModifier (*)( const XCAFDimTolObjects_GeomToleranceModif  ) >(&STEPCAFControl_GDTProperty::GetGeomToleranceModifier),
                    R"#(None)#"  , py::arg("theModifier")
          )
        .def_static("GetDatumRefModifiers_s",
                    (opencascade::handle<StepDimTol_HArray1OfDatumReferenceModifier> (*)(  const NCollection_Sequence<XCAFDimTolObjects_DatumSingleModif> & ,  const XCAFDimTolObjects_DatumModifWithValue & ,  const Standard_Real ,  const StepBasic_Unit &  ) ) static_cast<opencascade::handle<StepDimTol_HArray1OfDatumReferenceModifier> (*)(  const NCollection_Sequence<XCAFDimTolObjects_DatumSingleModif> & ,  const XCAFDimTolObjects_DatumModifWithValue & ,  const Standard_Real ,  const StepBasic_Unit &  ) >(&STEPCAFControl_GDTProperty::GetDatumRefModifiers),
                    R"#(None)#"  , py::arg("theModifiers"),  py::arg("theModifWithVal"),  py::arg("theValue"),  py::arg("theUnit")
          )
        .def_static("GetTessellation_s",
                    (opencascade::handle<StepVisual_TessellatedGeometricSet> (*)( const TopoDS_Shape &  ) ) static_cast<opencascade::handle<StepVisual_TessellatedGeometricSet> (*)( const TopoDS_Shape &  ) >(&STEPCAFControl_GDTProperty::GetTessellation),
                    R"#(None)#"  , py::arg("theShape")
          )
    // static methods using call by reference i.s.o. return
        .def_static("GetDimClassOfTolerance_s",
            [](const opencascade::handle<StepShape_LimitsAndFits> & theLAF,XCAFDimTolObjects_DimensionFormVariance & theFV,XCAFDimTolObjects_DimensionGrade & theG ){
                Standard_Boolean  theHolle;

                STEPCAFControl_GDTProperty::GetDimClassOfTolerance(theLAF,theHolle,theFV,theG);
                
return std::make_tuple(theHolle); },
            R"#(None)#"  , py::arg("theLAF"),  py::arg("theFV"),  py::arg("theG")
          )
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class STEPCAFControl_Provider from ./opencascade/STEPCAFControl_Provider.hxx
    klass = m.attr("STEPCAFControl_Provider");


    // nested enums

    static_cast<py::class_<STEPCAFControl_Provider ,opencascade::handle<STEPCAFControl_Provider>  , DE_Provider >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const opencascade::handle<DE_ConfigurationNode> & >()  , py::arg("theNode") )
    // custom constructors
    // methods
        .def("Read",
             (bool (STEPCAFControl_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) ) static_cast<bool (STEPCAFControl_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) >(&STEPCAFControl_Provider::Read),
             R"#(Reads a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theDocument"),  py::arg("theWS"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Write",
             (bool (STEPCAFControl_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) ) static_cast<bool (STEPCAFControl_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) >(&STEPCAFControl_Provider::Write),
             R"#(Writes a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theDocument"),  py::arg("theWS"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Read",
             (bool (STEPCAFControl_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) ) static_cast<bool (STEPCAFControl_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) >(&STEPCAFControl_Provider::Read),
             R"#(Reads a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theDocument"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Write",
             (bool (STEPCAFControl_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) ) static_cast<bool (STEPCAFControl_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) >(&STEPCAFControl_Provider::Write),
             R"#(Writes a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theDocument"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Read",
             (bool (STEPCAFControl_Provider::*)( const TCollection_AsciiString & ,  TopoDS_Shape & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) ) static_cast<bool (STEPCAFControl_Provider::*)( const TCollection_AsciiString & ,  TopoDS_Shape & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) >(&STEPCAFControl_Provider::Read),
             R"#(Reads a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theShape"),  py::arg("theWS"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Write",
             (bool (STEPCAFControl_Provider::*)( const TCollection_AsciiString & ,  const TopoDS_Shape & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) ) static_cast<bool (STEPCAFControl_Provider::*)( const TCollection_AsciiString & ,  const TopoDS_Shape & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) >(&STEPCAFControl_Provider::Write),
             R"#(Writes a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theShape"),  py::arg("theWS"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Read",
             (bool (STEPCAFControl_Provider::*)( const TCollection_AsciiString & ,  TopoDS_Shape & ,  const Message_ProgressRange &  ) ) static_cast<bool (STEPCAFControl_Provider::*)( const TCollection_AsciiString & ,  TopoDS_Shape & ,  const Message_ProgressRange &  ) >(&STEPCAFControl_Provider::Read),
             R"#(Reads a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theShape"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Write",
             (bool (STEPCAFControl_Provider::*)( const TCollection_AsciiString & ,  const TopoDS_Shape & ,  const Message_ProgressRange &  ) ) static_cast<bool (STEPCAFControl_Provider::*)( const TCollection_AsciiString & ,  const TopoDS_Shape & ,  const Message_ProgressRange &  ) >(&STEPCAFControl_Provider::Write),
             R"#(Writes a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theShape"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("GetFormat",
             (TCollection_AsciiString (STEPCAFControl_Provider::*)() const) static_cast<TCollection_AsciiString (STEPCAFControl_Provider::*)() const>(&STEPCAFControl_Provider::GetFormat),
             R"#(Gets CAD format name of associated provider)#" 
          )
        .def("GetVendor",
             (TCollection_AsciiString (STEPCAFControl_Provider::*)() const) static_cast<TCollection_AsciiString (STEPCAFControl_Provider::*)() const>(&STEPCAFControl_Provider::GetVendor),
             R"#(Gets provider's vendor name of associated provider)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&STEPCAFControl_Provider::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&STEPCAFControl_Provider::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (STEPCAFControl_Provider::*)() const) static_cast<const opencascade::handle<Standard_Type> & (STEPCAFControl_Provider::*)() const>(&STEPCAFControl_Provider::DynamicType),
             R"#(None)#"
             
         )
;

    // Class STEPCAFControl_Reader from ./opencascade/STEPCAFControl_Reader.hxx
    klass = m.attr("STEPCAFControl_Reader");


    // nested enums

    static_cast<py::class_<STEPCAFControl_Reader , shared_ptr<STEPCAFControl_Reader>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const opencascade::handle<XSControl_WorkSession> &,const Standard_Boolean >()  , py::arg("WS"),  py::arg("scratch")=static_cast<const Standard_Boolean>(Standard_True) )
    // custom constructors
    // methods
        .def("Init",
             (void (STEPCAFControl_Reader::*)( const opencascade::handle<XSControl_WorkSession> & ,  const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Reader::*)( const opencascade::handle<XSControl_WorkSession> & ,  const Standard_Boolean  ) >(&STEPCAFControl_Reader::Init),
             R"#(Clears the internal data structures and attaches to a new session Clears the session if it was not yet set for STEP)#"  , py::arg("WS"),  py::arg("scratch")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def("ReadFile",
             (IFSelect_ReturnStatus (STEPCAFControl_Reader::*)( const Standard_CString  ) ) static_cast<IFSelect_ReturnStatus (STEPCAFControl_Reader::*)( const Standard_CString  ) >(&STEPCAFControl_Reader::ReadFile),
             R"#(Loads a file and returns the read status Provided for use like single-file reader.)#"  , py::arg("theFileName")
          )
        .def("ReadFile",
             (IFSelect_ReturnStatus (STEPCAFControl_Reader::*)( const Standard_CString ,  const StepData_ConfParameters &  ) ) static_cast<IFSelect_ReturnStatus (STEPCAFControl_Reader::*)( const Standard_CString ,  const StepData_ConfParameters &  ) >(&STEPCAFControl_Reader::ReadFile),
             R"#(Loads a file and returns the read status Provided for use like single-file reader.)#"  , py::arg("theFileName"),  py::arg("theParams")
          )
        .def("ReadStream",
             (IFSelect_ReturnStatus (STEPCAFControl_Reader::*)( const Standard_CString ,  basic_istream<char> &  ) ) static_cast<IFSelect_ReturnStatus (STEPCAFControl_Reader::*)( const Standard_CString ,  basic_istream<char> &  ) >(&STEPCAFControl_Reader::ReadStream),
             R"#(Loads a file from stream and returns the read status.)#"  , py::arg("theName"),  py::arg("theIStream")
          )
        .def("NbRootsForTransfer",
             (Standard_Integer (STEPCAFControl_Reader::*)() ) static_cast<Standard_Integer (STEPCAFControl_Reader::*)() >(&STEPCAFControl_Reader::NbRootsForTransfer),
             R"#(Returns number of roots recognized for transfer Shortcut for Reader().NbRootsForTransfer())#" 
          )
        .def("TransferOneRoot",
             (Standard_Boolean (STEPCAFControl_Reader::*)( const Standard_Integer ,  const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)( const Standard_Integer ,  const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) >(&STEPCAFControl_Reader::TransferOneRoot),
             R"#(Translates currently loaded STEP file into the document Returns True if succeeded, and False in case of fail Provided for use like single-file reader)#"  , py::arg("num"),  py::arg("doc"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Transfer",
             (Standard_Boolean (STEPCAFControl_Reader::*)( const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)( const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) >(&STEPCAFControl_Reader::Transfer),
             R"#(Translates currently loaded STEP file into the document Returns True if succeeded, and False in case of fail Provided for use like single-file reader)#"  , py::arg("doc"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Perform",
             (Standard_Boolean (STEPCAFControl_Reader::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) >(&STEPCAFControl_Reader::Perform),
             R"#(None)#"  , py::arg("filename"),  py::arg("doc"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Perform",
             (Standard_Boolean (STEPCAFControl_Reader::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  const StepData_ConfParameters & ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  const StepData_ConfParameters & ,  const Message_ProgressRange &  ) >(&STEPCAFControl_Reader::Perform),
             R"#(None)#"  , py::arg("filename"),  py::arg("doc"),  py::arg("theParams"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Perform",
             (Standard_Boolean (STEPCAFControl_Reader::*)( const Standard_CString ,  const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)( const Standard_CString ,  const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) >(&STEPCAFControl_Reader::Perform),
             R"#(Translate STEP file given by filename into the document Return True if succeeded, and False in case of fail)#"  , py::arg("filename"),  py::arg("doc"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Perform",
             (Standard_Boolean (STEPCAFControl_Reader::*)( const Standard_CString ,  const opencascade::handle<TDocStd_Document> & ,  const StepData_ConfParameters & ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)( const Standard_CString ,  const opencascade::handle<TDocStd_Document> & ,  const StepData_ConfParameters & ,  const Message_ProgressRange &  ) >(&STEPCAFControl_Reader::Perform),
             R"#(Translate STEP file given by filename into the document Return True if succeeded, and False in case of fail)#"  , py::arg("filename"),  py::arg("doc"),  py::arg("theParams"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("ExternFile",
             (Standard_Boolean (STEPCAFControl_Reader::*)( const Standard_CString ,  opencascade::handle<STEPCAFControl_ExternFile> &  ) const) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)( const Standard_CString ,  opencascade::handle<STEPCAFControl_ExternFile> &  ) const>(&STEPCAFControl_Reader::ExternFile),
             R"#(Returns data on external file by its name Returns False if no external file with given name is read)#"  , py::arg("name"),  py::arg("ef")
          )
        .def("SetColorMode",
             (void (STEPCAFControl_Reader::*)( const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Reader::*)( const Standard_Boolean  ) >(&STEPCAFControl_Reader::SetColorMode),
             R"#(Set ColorMode for indicate read Colors or not.)#"  , py::arg("colormode")
          )
        .def("GetColorMode",
             (Standard_Boolean (STEPCAFControl_Reader::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)() const>(&STEPCAFControl_Reader::GetColorMode),
             R"#(None)#" 
          )
        .def("SetNameMode",
             (void (STEPCAFControl_Reader::*)( const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Reader::*)( const Standard_Boolean  ) >(&STEPCAFControl_Reader::SetNameMode),
             R"#(Set NameMode for indicate read Name or not.)#"  , py::arg("namemode")
          )
        .def("GetNameMode",
             (Standard_Boolean (STEPCAFControl_Reader::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)() const>(&STEPCAFControl_Reader::GetNameMode),
             R"#(None)#" 
          )
        .def("SetLayerMode",
             (void (STEPCAFControl_Reader::*)( const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Reader::*)( const Standard_Boolean  ) >(&STEPCAFControl_Reader::SetLayerMode),
             R"#(Set LayerMode for indicate read Layers or not.)#"  , py::arg("layermode")
          )
        .def("GetLayerMode",
             (Standard_Boolean (STEPCAFControl_Reader::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)() const>(&STEPCAFControl_Reader::GetLayerMode),
             R"#(None)#" 
          )
        .def("SetPropsMode",
             (void (STEPCAFControl_Reader::*)( const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Reader::*)( const Standard_Boolean  ) >(&STEPCAFControl_Reader::SetPropsMode),
             R"#(PropsMode for indicate read Validation properties or not.)#"  , py::arg("propsmode")
          )
        .def("GetPropsMode",
             (Standard_Boolean (STEPCAFControl_Reader::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)() const>(&STEPCAFControl_Reader::GetPropsMode),
             R"#(None)#" 
          )
        .def("SetSHUOMode",
             (void (STEPCAFControl_Reader::*)( const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Reader::*)( const Standard_Boolean  ) >(&STEPCAFControl_Reader::SetSHUOMode),
             R"#(Set SHUO mode for indicate write SHUO or not.)#"  , py::arg("shuomode")
          )
        .def("GetSHUOMode",
             (Standard_Boolean (STEPCAFControl_Reader::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)() const>(&STEPCAFControl_Reader::GetSHUOMode),
             R"#(None)#" 
          )
        .def("SetGDTMode",
             (void (STEPCAFControl_Reader::*)( const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Reader::*)( const Standard_Boolean  ) >(&STEPCAFControl_Reader::SetGDTMode),
             R"#(Set GDT mode for indicate write GDT or not.)#"  , py::arg("gdtmode")
          )
        .def("GetGDTMode",
             (Standard_Boolean (STEPCAFControl_Reader::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)() const>(&STEPCAFControl_Reader::GetGDTMode),
             R"#(None)#" 
          )
        .def("SetMatMode",
             (void (STEPCAFControl_Reader::*)( const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Reader::*)( const Standard_Boolean  ) >(&STEPCAFControl_Reader::SetMatMode),
             R"#(Set Material mode)#"  , py::arg("matmode")
          )
        .def("GetMatMode",
             (Standard_Boolean (STEPCAFControl_Reader::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)() const>(&STEPCAFControl_Reader::GetMatMode),
             R"#(None)#" 
          )
        .def("SetViewMode",
             (void (STEPCAFControl_Reader::*)( const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Reader::*)( const Standard_Boolean  ) >(&STEPCAFControl_Reader::SetViewMode),
             R"#(Set View mode)#"  , py::arg("viewmode")
          )
        .def("GetViewMode",
             (Standard_Boolean (STEPCAFControl_Reader::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)() const>(&STEPCAFControl_Reader::GetViewMode),
             R"#(Get View mode)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("FindInstance_s",
                    (TDF_Label (*)( const opencascade::handle<StepRepr_NextAssemblyUsageOccurrence> & ,  const opencascade::handle<XCAFDoc_ShapeTool> & ,  const STEPConstruct_Tool & ,   const NCollection_DataMap<TopoDS_Shape, TDF_Label, TopTools_ShapeMapHasher> &  ) ) static_cast<TDF_Label (*)( const opencascade::handle<StepRepr_NextAssemblyUsageOccurrence> & ,  const opencascade::handle<XCAFDoc_ShapeTool> & ,  const STEPConstruct_Tool & ,   const NCollection_DataMap<TopoDS_Shape, TDF_Label, TopTools_ShapeMapHasher> &  ) >(&STEPCAFControl_Reader::FindInstance),
                    R"#(Returns label of instance of an assembly component corresponding to a given NAUO)#"  , py::arg("NAUO"),  py::arg("STool"),  py::arg("Tool"),  py::arg("ShapeLabelMap")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ExternFiles",
             (const NCollection_DataMap<TCollection_AsciiString, opencascade::handle<STEPCAFControl_ExternFile>> & (STEPCAFControl_Reader::*)() const) static_cast<const NCollection_DataMap<TCollection_AsciiString, opencascade::handle<STEPCAFControl_ExternFile>> & (STEPCAFControl_Reader::*)() const>(&STEPCAFControl_Reader::ExternFiles),
             R"#(Returns data on external files Returns Null handle if no external files are read)#"
             
         )
       .def("ChangeReader",
             (STEPControl_Reader & (STEPCAFControl_Reader::*)() ) static_cast<STEPControl_Reader & (STEPCAFControl_Reader::*)() >(&STEPCAFControl_Reader::ChangeReader),
             R"#(Returns basic reader)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("Reader",
             (const STEPControl_Reader & (STEPCAFControl_Reader::*)() const) static_cast<const STEPControl_Reader & (STEPCAFControl_Reader::*)() const>(&STEPCAFControl_Reader::Reader),
             R"#(Returns basic reader as const)#"
             
         )
       .def("GetShapeLabelMap",
             (const XCAFDoc_DataMapOfShapeLabel & (STEPCAFControl_Reader::*)() const) static_cast<const XCAFDoc_DataMapOfShapeLabel & (STEPCAFControl_Reader::*)() const>(&STEPCAFControl_Reader::GetShapeLabelMap),
             R"#(None)#"
             
         )
;

    // Class STEPCAFControl_Writer from ./opencascade/STEPCAFControl_Writer.hxx
    klass = m.attr("STEPCAFControl_Writer");


    // nested enums

    static_cast<py::class_<STEPCAFControl_Writer , shared_ptr<STEPCAFControl_Writer>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const opencascade::handle<XSControl_WorkSession> &,const Standard_Boolean >()  , py::arg("theWS"),  py::arg("theScratch")=static_cast<const Standard_Boolean>(Standard_True) )
    // custom constructors
    // methods
        .def("Init",
             (void (STEPCAFControl_Writer::*)( const opencascade::handle<XSControl_WorkSession> & ,  const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Writer::*)( const opencascade::handle<XSControl_WorkSession> & ,  const Standard_Boolean  ) >(&STEPCAFControl_Writer::Init),
             R"#(Clears the internal data structures and attaches to a new session Clears the session if it was not yet set for STEP)#"  , py::arg("theWS"),  py::arg("theScratch")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def("Write",
             (IFSelect_ReturnStatus (STEPCAFControl_Writer::*)( const Standard_CString  ) ) static_cast<IFSelect_ReturnStatus (STEPCAFControl_Writer::*)( const Standard_CString  ) >(&STEPCAFControl_Writer::Write),
             R"#(Writes all the produced models into file In case of multimodel with extern references, filename will be a name of root file, all other files have names of corresponding parts Provided for use like single-file writer)#"  , py::arg("theFileName")
          )
        .def("WriteStream",
             (IFSelect_ReturnStatus (STEPCAFControl_Writer::*)( basic_ostream<char> &  ) ) static_cast<IFSelect_ReturnStatus (STEPCAFControl_Writer::*)( basic_ostream<char> &  ) >(&STEPCAFControl_Writer::WriteStream),
             R"#(Writes all the produced models into the stream. Provided for use like single-file writer)#"  , py::arg("theStream")
          )
        .def("Transfer",
             (Standard_Boolean (STEPCAFControl_Writer::*)( const opencascade::handle<TDocStd_Document> & ,  const STEPControl_StepModelType ,  const Standard_CString ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)( const opencascade::handle<TDocStd_Document> & ,  const STEPControl_StepModelType ,  const Standard_CString ,  const Message_ProgressRange &  ) >(&STEPCAFControl_Writer::Transfer),
             R"#(Transfers a document (or single label) to a STEP model The mode of translation of shape is AsIs If multi is not null pointer, it switches to multifile mode (with external refs), and string pointed by <multi> gives prefix for names of extern files (can be empty string) Returns True if translation is OK)#"  , py::arg("theDoc"),  py::arg("theMode")=static_cast<const STEPControl_StepModelType>(STEPControl_AsIs),  py::arg("theIsMulti")=static_cast<const Standard_CString>(0),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Transfer",
             (Standard_Boolean (STEPCAFControl_Writer::*)( const opencascade::handle<TDocStd_Document> & ,  const StepData_ConfParameters & ,  const STEPControl_StepModelType ,  const Standard_CString ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)( const opencascade::handle<TDocStd_Document> & ,  const StepData_ConfParameters & ,  const STEPControl_StepModelType ,  const Standard_CString ,  const Message_ProgressRange &  ) >(&STEPCAFControl_Writer::Transfer),
             R"#(Transfers a document (or single label) to a STEP model This method uses if need to set parameters avoiding initialization from Interface_Static)#"  , py::arg("theDoc"),  py::arg("theParams"),  py::arg("theMode")=static_cast<const STEPControl_StepModelType>(STEPControl_AsIs),  py::arg("theIsMulti")=static_cast<const Standard_CString>(0),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Transfer",
             (Standard_Boolean (STEPCAFControl_Writer::*)( const TDF_Label & ,  const STEPControl_StepModelType ,  const Standard_CString ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)( const TDF_Label & ,  const STEPControl_StepModelType ,  const Standard_CString ,  const Message_ProgressRange &  ) >(&STEPCAFControl_Writer::Transfer),
             R"#(Method to transfer part of the document specified by label)#"  , py::arg("theLabel"),  py::arg("theMode")=static_cast<const STEPControl_StepModelType>(STEPControl_AsIs),  py::arg("theIsMulti")=static_cast<const Standard_CString>(0),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Transfer",
             (Standard_Boolean (STEPCAFControl_Writer::*)( const TDF_Label & ,  const StepData_ConfParameters & ,  const STEPControl_StepModelType ,  const Standard_CString ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)( const TDF_Label & ,  const StepData_ConfParameters & ,  const STEPControl_StepModelType ,  const Standard_CString ,  const Message_ProgressRange &  ) >(&STEPCAFControl_Writer::Transfer),
             R"#(Method to transfer part of the document specified by label This method uses if need to set parameters avoiding initialization from Interface_Static)#"  , py::arg("theLabel"),  py::arg("theParams"),  py::arg("theMode")=static_cast<const STEPControl_StepModelType>(STEPControl_AsIs),  py::arg("theIsMulti")=static_cast<const Standard_CString>(0),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Transfer",
             (Standard_Boolean (STEPCAFControl_Writer::*)(  const NCollection_Sequence<TDF_Label> & ,  const STEPControl_StepModelType ,  const Standard_CString ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)(  const NCollection_Sequence<TDF_Label> & ,  const STEPControl_StepModelType ,  const Standard_CString ,  const Message_ProgressRange &  ) >(&STEPCAFControl_Writer::Transfer),
             R"#(Mehod to writing sequence of root assemblies or part of the file specified by use by one label)#"  , py::arg("theLabelSeq"),  py::arg("theMode")=static_cast<const STEPControl_StepModelType>(STEPControl_AsIs),  py::arg("theIsMulti")=static_cast<const Standard_CString>(0),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Transfer",
             (Standard_Boolean (STEPCAFControl_Writer::*)(  const NCollection_Sequence<TDF_Label> & ,  const StepData_ConfParameters & ,  const STEPControl_StepModelType ,  const Standard_CString ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)(  const NCollection_Sequence<TDF_Label> & ,  const StepData_ConfParameters & ,  const STEPControl_StepModelType ,  const Standard_CString ,  const Message_ProgressRange &  ) >(&STEPCAFControl_Writer::Transfer),
             R"#(Mehod to writing sequence of root assemblies or part of the file specified by use by one label This method uses if need to set parameters avoiding initialization from Interface_Static)#"  , py::arg("theLabelSeq"),  py::arg("theParams"),  py::arg("theMode")=static_cast<const STEPControl_StepModelType>(STEPControl_AsIs),  py::arg("theIsMulti")=static_cast<const Standard_CString>(0),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Perform",
             (Standard_Boolean (STEPCAFControl_Writer::*)( const opencascade::handle<TDocStd_Document> & ,  const TCollection_AsciiString & ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)( const opencascade::handle<TDocStd_Document> & ,  const TCollection_AsciiString & ,  const Message_ProgressRange &  ) >(&STEPCAFControl_Writer::Perform),
             R"#(None)#"  , py::arg("theDoc"),  py::arg("theFileName"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Perform",
             (Standard_Boolean (STEPCAFControl_Writer::*)( const opencascade::handle<TDocStd_Document> & ,  const Standard_CString ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)( const opencascade::handle<TDocStd_Document> & ,  const Standard_CString ,  const Message_ProgressRange &  ) >(&STEPCAFControl_Writer::Perform),
             R"#(Transfers a document and writes it to a STEP file Returns True if translation is OK)#"  , py::arg("theDoc"),  py::arg("theFileName"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Perform",
             (Standard_Boolean (STEPCAFControl_Writer::*)( const opencascade::handle<TDocStd_Document> & ,  const Standard_CString ,  const StepData_ConfParameters & ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)( const opencascade::handle<TDocStd_Document> & ,  const Standard_CString ,  const StepData_ConfParameters & ,  const Message_ProgressRange &  ) >(&STEPCAFControl_Writer::Perform),
             R"#(Transfers a document and writes it to a STEP file This method uses if need to set parameters avoiding initialization from Interface_Static Returns True if translation is OK)#"  , py::arg("theDoc"),  py::arg("theFileName"),  py::arg("theParams"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("ExternFile",
             (Standard_Boolean (STEPCAFControl_Writer::*)( const TDF_Label & ,  opencascade::handle<STEPCAFControl_ExternFile> &  ) const) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)( const TDF_Label & ,  opencascade::handle<STEPCAFControl_ExternFile> &  ) const>(&STEPCAFControl_Writer::ExternFile),
             R"#(Returns data on external file by its original label Returns False if no external file with given name is read)#"  , py::arg("theLabel"),  py::arg("theExtFile")
          )
        .def("ExternFile",
             (Standard_Boolean (STEPCAFControl_Writer::*)( const Standard_CString ,  opencascade::handle<STEPCAFControl_ExternFile> &  ) const) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)( const Standard_CString ,  opencascade::handle<STEPCAFControl_ExternFile> &  ) const>(&STEPCAFControl_Writer::ExternFile),
             R"#(Returns data on external file by its name Returns False if no external file with given name is read)#"  , py::arg("theName"),  py::arg("theExtFile")
          )
        .def("SetColorMode",
             (void (STEPCAFControl_Writer::*)( const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Writer::*)( const Standard_Boolean  ) >(&STEPCAFControl_Writer::SetColorMode),
             R"#(Set ColorMode for indicate write Colors or not.)#"  , py::arg("theColorMode")
          )
        .def("GetColorMode",
             (Standard_Boolean (STEPCAFControl_Writer::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)() const>(&STEPCAFControl_Writer::GetColorMode),
             R"#(None)#" 
          )
        .def("SetNameMode",
             (void (STEPCAFControl_Writer::*)( const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Writer::*)( const Standard_Boolean  ) >(&STEPCAFControl_Writer::SetNameMode),
             R"#(Set NameMode for indicate write Name or not.)#"  , py::arg("theNameMode")
          )
        .def("GetNameMode",
             (Standard_Boolean (STEPCAFControl_Writer::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)() const>(&STEPCAFControl_Writer::GetNameMode),
             R"#(None)#" 
          )
        .def("SetLayerMode",
             (void (STEPCAFControl_Writer::*)( const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Writer::*)( const Standard_Boolean  ) >(&STEPCAFControl_Writer::SetLayerMode),
             R"#(Set LayerMode for indicate write Layers or not.)#"  , py::arg("theLayerMode")
          )
        .def("GetLayerMode",
             (Standard_Boolean (STEPCAFControl_Writer::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)() const>(&STEPCAFControl_Writer::GetLayerMode),
             R"#(None)#" 
          )
        .def("SetPropsMode",
             (void (STEPCAFControl_Writer::*)( const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Writer::*)( const Standard_Boolean  ) >(&STEPCAFControl_Writer::SetPropsMode),
             R"#(PropsMode for indicate write Validation properties or not.)#"  , py::arg("thePropsMode")
          )
        .def("GetPropsMode",
             (Standard_Boolean (STEPCAFControl_Writer::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)() const>(&STEPCAFControl_Writer::GetPropsMode),
             R"#(None)#" 
          )
        .def("SetSHUOMode",
             (void (STEPCAFControl_Writer::*)( const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Writer::*)( const Standard_Boolean  ) >(&STEPCAFControl_Writer::SetSHUOMode),
             R"#(Set SHUO mode for indicate write SHUO or not.)#"  , py::arg("theSHUOMode")
          )
        .def("GetSHUOMode",
             (Standard_Boolean (STEPCAFControl_Writer::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)() const>(&STEPCAFControl_Writer::GetSHUOMode),
             R"#(None)#" 
          )
        .def("SetDimTolMode",
             (void (STEPCAFControl_Writer::*)( const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Writer::*)( const Standard_Boolean  ) >(&STEPCAFControl_Writer::SetDimTolMode),
             R"#(Set dimtolmode for indicate write D&GTs or not.)#"  , py::arg("theDimTolMode")
          )
        .def("GetDimTolMode",
             (Standard_Boolean (STEPCAFControl_Writer::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)() const>(&STEPCAFControl_Writer::GetDimTolMode),
             R"#(None)#" 
          )
        .def("SetMaterialMode",
             (void (STEPCAFControl_Writer::*)( const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Writer::*)( const Standard_Boolean  ) >(&STEPCAFControl_Writer::SetMaterialMode),
             R"#(Set dimtolmode for indicate write D&GTs or not.)#"  , py::arg("theMaterialMode")
          )
        .def("GetMaterialMode",
             (Standard_Boolean (STEPCAFControl_Writer::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)() const>(&STEPCAFControl_Writer::GetMaterialMode),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ExternFiles",
             (const NCollection_DataMap<TCollection_AsciiString, opencascade::handle<STEPCAFControl_ExternFile>> & (STEPCAFControl_Writer::*)() const) static_cast<const NCollection_DataMap<TCollection_AsciiString, opencascade::handle<STEPCAFControl_ExternFile>> & (STEPCAFControl_Writer::*)() const>(&STEPCAFControl_Writer::ExternFiles),
             R"#(Returns data on external files Returns Null handle if no external files are read)#"
             
         )
       .def("ChangeWriter",
             (STEPControl_Writer & (STEPCAFControl_Writer::*)() ) static_cast<STEPControl_Writer & (STEPCAFControl_Writer::*)() >(&STEPCAFControl_Writer::ChangeWriter),
             R"#(Returns basic reader for root file)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("Writer",
             (const STEPControl_Writer & (STEPCAFControl_Writer::*)() const) static_cast<const STEPControl_Writer & (STEPCAFControl_Writer::*)() const>(&STEPCAFControl_Writer::Writer),
             R"#(Returns basic reader as const)#"
             
         )
;

// functions
// ./opencascade/STEPCAFControl_ActorWrite.hxx
// ./opencascade/STEPCAFControl_ConfigurationNode.hxx
// ./opencascade/STEPCAFControl_Controller.hxx
// ./opencascade/STEPCAFControl_DataMapIteratorOfDataMapOfLabelExternFile.hxx
// ./opencascade/STEPCAFControl_DataMapIteratorOfDataMapOfLabelShape.hxx
// ./opencascade/STEPCAFControl_DataMapIteratorOfDataMapOfPDExternFile.hxx
// ./opencascade/STEPCAFControl_DataMapIteratorOfDataMapOfSDRExternFile.hxx
// ./opencascade/STEPCAFControl_DataMapIteratorOfDataMapOfShapePD.hxx
// ./opencascade/STEPCAFControl_DataMapIteratorOfDataMapOfShapeSDR.hxx
// ./opencascade/STEPCAFControl_DataMapOfLabelExternFile.hxx
// ./opencascade/STEPCAFControl_DataMapOfLabelShape.hxx
// ./opencascade/STEPCAFControl_DataMapOfPDExternFile.hxx
// ./opencascade/STEPCAFControl_DataMapOfSDRExternFile.hxx
// ./opencascade/STEPCAFControl_DataMapOfShapePD.hxx
// ./opencascade/STEPCAFControl_DataMapOfShapeSDR.hxx
// ./opencascade/STEPCAFControl_ExternFile.hxx
// ./opencascade/STEPCAFControl_GDTProperty.hxx
// ./opencascade/STEPCAFControl_Provider.hxx
// ./opencascade/STEPCAFControl_Reader.hxx
// ./opencascade/STEPCAFControl_Writer.hxx

// Additional functions

// operators

// register typdefs
    register_template_NCollection_DataMap<TDF_Label, TopoDS_Shape>(m,"STEPCAFControl_DataMapOfLabelShape");


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
